; change these in case you need to fit him in a different spot
!KrackEyeFrame = $CA
!KrackBodyTop = $C8
!KrackBodyBottom = $E8
!AngyKrackMiddleLeft = $E0
!AngyKrackBottomLeft = $ED
!AngyKrackTopRight = $EB
!AngyKrackBottomRight = $EE




	!addr = !Base2
    !rom = !BankB

;########################################
;######## Scratchs Rams [$00,$0F] #######
;########################################
!Scratch0 = $00
!Scratch1 = $01
!Scratch2 = $02
!Scratch3 = $03
!Scratch4 = $04
!Scratch5 = $05
!Scratch6 = $06
!Scratch7 = $07
!Scratch8 = $08
!Scratch9 = $09
!ScratchA = $0A
!ScratchB = $0B
!ScratchC = $0C
!ScratchD = $0D
!ScratchE = $0E
!ScratchF = $0F

;########################################
;############## Counters ################
;########################################
!TrueFrameCounter = $13
!EffectiveFrameCounter = $14

;########################################
;############## Control #################
;########################################
!ButtonPressed_BYETUDLR = $15
!ButtonDown_BYETUDLR = $16
!ButtonPressed_AXLR0000 = $17
!ButtonDown_AXLR0000 = $18

;########################################
;############## Layers ##################
;########################################
!Layer1X = $1A
!Layer1Y = $1C
!Layer2X = $1E
!Layer2Y = $20
!Layer3X = $22
!Layer3Y = $24

;########################################
;############## Player ##################
;########################################
!PlayerX = $94
!PlayerY = $96
!PlayerXSpeed = $7B
!PlayerYSpeed = $7D
!PowerUp = $19
!Lives = $0DBE|!addr
!Coins = $0DBF|!addr
!ItemBox = $0DC2|!addr
!PlayerInAirFlag = $72
!PlayerDuckingFlag = $73
!PlayerClimbingFlag_N00SIFHB = $74
!PlayerWaterFlag = $75
!PlayerDirection = $76
!PlayerBlockedStatus_S00MUDLR = $77
!PlayerHide_DLUCAPLU = $78
!CurrentPlayer = $0DB3|!addr
!CapeImage = $13DF|!addr
!PlayerPose = $13E0|!addr
!PlayerSlope = $13E1|!addr
!SpinjumpTimer = $13E2|!addr
!PlayerWallRunningFlag = $13E3|!addr
!PlayerFrozenFlag = $13FB|!addr
!PlayerCarryingFlag = $1470|!addr
!PlayerCarryingFlagImage = $148F|!addr
!PlayerAnimationTimer = $1496|!addr
!PlayerFlashingTimer = $1497|!addr
!P1PowerUp = $0DB8|!addr
!P2PowerUp = $0DB9|!addr
!P1Lives = $0DB4|!addr
!P2Lives = $0DB5|!addr
!P1Coins = $0DB6|!addr
!P2Coins = $0DB7|!addr
!P1YoshiColor = $0DBA|!addr
!P2YoshiColor = $0DBB|!addr
!P1ItemBox = $0DBC|!addr
!P2ItemBox = $0DBD|!addr

;########################################
;############### Global #################
;########################################
!LockAnimationFlag = $9D
!HScrollEnable = $1411|!addr
!VScrollEnable = $1412|!addr
!HScrollLayer2Type = $1413|!addr
!VScrollLayer2Type = $1414|!addr
!WaterFlag = $85
!SlipperyFlag = $86
!GameMode = $0100|!addr
!TwoPlayersFlag = $0DB2|!addr

;########################################
;################ OAM ###################
;########################################
!TileXPosition200 = $0200|!addr
!TileYPosition200 = $0201|!addr
!TileCode200 = $0202|!addr
!TileProperty200 = $0203|!addr
!TileSize420 = $0420|!addr
!TileXPosition = $0300|!addr
!TileYPosition = $0301|!addr
!TileCode = $0302|!addr
!TileProperty = $0303|!addr
!TileSize460 = $0460|!addr

;########################################
;############### Yoshi ##################
;########################################
!YoshiX = $18B0|!addr
!YoshiY = $18B2|!addr
!YoshiKeyInMouthFlag = $191C|!addr

;########################################
;############## Clusters ################
;########################################
!ClusterNumber = $1892|!addr
!ClusterXLow = $1E16|!addr
!ClusterYLow = $1E02|!addr
!ClusterXHigh = $1E3E|!addr
!ClusterYHigh = $1E2A|!addr
!ClusterMiscTable1 = $0F4A|!addr
!ClusterMiscTable2 = $0F5E|!addr
!ClusterMiscTable3 = $0F72|!addr
!ClusterMiscTable4 = $0F86|!addr
!ClusterMiscTable5 = $0F9A|!addr
!ClusterMiscTable6 = $1E52|!addr
!ClusterMiscTable7 = $1E66|!addr
!ClusterMiscTable8 = $1E7A|!addr
!ClusterMiscTable9 = $1E8E|!addr

;########################################
;############## Extended ################
;########################################
!ExtendedNumber = $170B|!addr
!ExtendedXLow = $171F|!addr
!ExtendedYLow = $1715|!addr
!ExtendedXHigh = $1733|!addr
!ExtendedYHigh = $1729|!addr
!ExtendedXSpeed = $1747|!addr
!ExtendedYSpeed = $173D|!addr
!ExtendedXSpeedAccumulatingFraction = $175B|!addr
!ExtendedYSpeedAccumulatingFraction = $1751|!addr
!ExtendedBehindLayersFlag = $1779|!addr
!ExtendedMiscTable1 = $1765|!addr
!ExtendedMiscTable2 = $176F|!addr

;########################################
;############### Sprites ################
;########################################
!SpriteIndex = $15E9|!addr
!SpriteNumber = !9E
!SpriteStatus = !14C8
!SpriteXLow = !E4
!SpriteYLow = !D8
!SpriteXHigh = !14E0
!SpriteYHigh = !14D4
!SpriteXSpeed = !B6
!SpriteYSpeed = !AA
!SpriteXSpeedAccumulatingFraction = !14F8
!SpriteYSpeedAccumulatingFraction = !14EC
!SpriteDirection = !157C
!SpriteBlockedStatus_ASB0UDLR = !1588
!SpriteHOffScreenFlag = !15A0
!SpriteVOffScreenFlag = !186C
!SpriteHMoreThan4TilesOffScreenFlag = !15C4
!SpriteSlope = !15B8
!SpriteYoshiTongueFlag = !15D0
!SpriteInteractionWithObjectEnable = !15DC
!SpriteIndexOAM = !15EA
!SpriteProperties_YXPPCCCT = !15F6
!SpriteLoadStatus = !161A
!SpriteBehindEscenaryFlag = !1632
!SpriteInLiquidFlag = !164A
!SpriteDecTimer1 = !1540
!SpriteDecTimer2 = !154C
!SpriteDecTimer3 = !1558
!SpriteDecTimer4 = !1564
!SpriteDecTimer5 = !15AC
!SpriteDecTimer6 = !163E
!SpriteDecTimer7 = !1FE2
!SpriteTweaker1656_SSJJCCCC = !1656
!SpriteTweaker1662_DSCCCCCC = !1662
!SpriteTweaker166E_LWCFPPPG = !166E
!SpriteTweaker167A_DPMKSPIS = !167A
!SpriteTweaker1686_DNCTSWYE = !1686
!SpriteTweaker190F_WCDJ5SDP = !190F
!SpriteMiscTable3 = !C2
!SpriteMiscTable4 = !1504
!SpriteMiscTable5 = !1510
!SpriteMiscTable6 = !151C
!SpriteMiscTable7 = !1528
!SpriteMiscTable8 = !1534
!SpriteMiscTable9 = !1570
!SpriteMiscTable10 = !1594
!SpriteMiscTable11 = !1602
!SpriteMiscTable12 = !160E
!SpriteMiscTable13 = !1626
!SpriteMiscTable14 = !187B
!SpriteMiscTable15 = !1FD6

;########################################
;############### GIEPY ##################
;########################################
!ExtraBits = !7FAB10
!NewCodeFlag = $7FAB1C
!ExtraProp1 = !7FAB28
!ExtraProp2 = !7FAB34
!ExtraByte1 = !7FAB40
!ExtraByte2 = !7FAB4C
!ExtraByte3 = !7FAB58
!ExtraByte4 = !7FAB64
!ShooterExtraByte = $7FAB70
!GeneratorExtraByte = $7FAB78
!ScrollerExtraByte = $7FAB79
!CustomSpriteNumber = $7FAB9E
!ShooterExtraBits = $7FABAA
!GeneratorExtraBits = $7FABB2
!Layer1ExtraBits = $7FABB3
!Layer2ExtraBits = $7FABB4
!SpriteFlags = $7FABB5

;######################################
;############## Defines ###############
;######################################

!FrameIndex = !SpriteMiscTable3
!AnimationTimer = !SpriteDecTimer1
!AnimationIndex = !SpriteMiscTable4
!AnimationFrameIndex = !SpriteMiscTable8
!LocalFlip = !SpriteMiscTable6
!GlobalFlip = !SpriteMiscTable7

!OhNoSubstates = !SpriteMiscTable9
!SpriteXLowTarget = !SpriteMiscTable10
!SpriteXHighTarget = !SpriteMiscTable11

!AimTimer = !SpriteDecTimer2
!NoHitTimer = !SpriteDecTimer4

;######################################
;########### Init Routine #############
;######################################
print "INIT ",pc
	LDA #$00
	STA !GlobalFlip,x
	JSL InitWrapperChangeAnimationFromStart
    ;Here you can write your Init Code
    ;This will be excecuted when the sprite is spawned 
RTL

;######################################
;########## Main Routine ##############
;######################################
print "MAIN ",pc
    PHB
    PHK
    PLB
    JSR SpriteCode
    JSR InteractMarioSprite
    JSR AnimationRoutine                ;Calls animation routine and decides the next frame to draw
    JSR GraphicRoutine
    PLB
RTL

;>Routine: SpriteCode
;>Description: This routine excecute the logic of the sprite
;>RoutineLength: Short
Return:
RTS
SpriteCode:
    LDA !SpriteStatus,x			        
	CMP #$08                            ;if sprite dead return
	BNE Return	

	LDA !LockAnimationFlag				    
	BNE Return			                    ;if locked animation return.

    
	LDA !AnimationIndex,x
	BNE + : RTS : +
	
	; If timer runs out, reset it and store Mario's x pose to Krack's target location
	LDA !AimTimer,x
	BNE +
	%SubHorzPos()
	TYA : EOR #$01 : STA !GlobalFlip,x
	LDA $94 : STA !SpriteXLowTarget,x
	LDA $95 : STA !SpriteXHighTarget,x
	LDA !extra_byte_1,x : STA !AimTimer,x
	LDA #$26 : STA $1DFC|!Base2 ; swooper sfx
+
	; 16bit value of Sprite's "target" x position
	LDA !SpriteXLowTarget,x : STA $00
	LDA !SpriteXHighTarget,x : STA $01
	
	; 16bit value of Sprite's x position
	LDA !sprite_x_low,x : STA $02
	LDA !sprite_x_high,x : STA $03

	; Find the middle of the two numbers
	REP #$20
	LDA $00 : CLC : ADC $02 ; Add the values of the sprite vs target location
	LSR A ; Divide it by 2
	SEP #$20	
	STA !sprite_x_low,x : XBA : STA !sprite_x_high,x ; Store it to sprite's x position.
	
	; Animation logic
	LDA #$01 : STA $00 ; save #$01
	LDA !AimTimer,x : CMP #$20
	BCS + : LDA #$02 : STA $00
+	LDA $00 : STA !AnimationIndex,x
	RTS

;>EndRoutine

;######################################
;######## Sub Routine Space ###########
;######################################

;Here you can write routines or tables

;Don't Delete or write another >Section Graphics or >End Section
;All code between >Section Graphics and >End Graphics Section will be changed by Dyzen : Sprite Maker
;>Section Graphics
;######################################
;########## Graphics Space ############
;######################################

;This space is for routines used for graphics
;if you don't know enough about asm then
;don't edit them.

;>Routine: GraphicRoutine
;>Description: Updates tiles on the oam map
;results will be visible the next frame.
;>RoutineLength: Short
GraphicRoutine:

    %GetDrawInfo()                     ;Calls GetDrawInfo to get the free slot and the XDisp and YDisp

    STZ !Scratch3                       ;$02 = Free Slot but in 16bits
    STY !Scratch2


    STZ !Scratch5
    LDA !GlobalFlip,x   
    STA !ScratchF
    ASL
    STA !Scratch4                       ;$04 = Global Flip but in 16bits
    LDA !ScratchF
    CLC
    ROR A
    ROR A 
    ROR A
    STA !ScratchF


    PHX                                 ;Preserve X
    
    STZ !Scratch7
    LDA !FrameIndex,x
    STA !Scratch6                       ;$06 = Frame Index but in 16bits

    REP #$30                            ;A/X/Y 16bits mode
    LDY !Scratch4                       ;Y = Global Flip
    LDA !Scratch6
    ASL
	CLC
    ADC FramesFlippers,y
    TAX                                 ;X = Frame Index

    LDA FramesLength,x
    CMP #$FFFF
    BNE +
    SEP #$30
    PLX
    RTS
+
    STA !Scratch8

    LDA FramesEndPosition,x
    STA !Scratch4                       ;$04 = End Position + A value used to select a frame version that is flipped

    LDA FramesStartPosition,x           
    TAX                                 ;X = Start Position
    SEP #$20                            ;A 8bits mode
    LDY !Scratch2                       ;Y = Free Slot
    CPY #$00FD
    BCS .return                         ;Y can't be more than #$00FD
-
    LDA Tiles,x
    STA !TileCode,y                     ;Set the Tile code of the tile Y

	LDA #$2F
    EOR !ScratchF
    STA !TileProperty,y                 ;Set the Tile property of the tile Y

    LDA !Scratch0
	CLC
	ADC XDisplacements,x
	STA !TileXPosition,y                ;Set the Tile x pos of the tile Y

    LDA !Scratch1
	CLC
	ADC YDisplacements,x
	STA !TileYPosition,y                ;Set the Tile y pos of the tile Y

    PHY
	REP #$20                                 
    TYA
    LSR
    LSR
    TAY                                 ;Y = Y/4 because size directions are not continuous to map 200 and 300
	SEP #$20
    LDA Sizes,x
    STA !TileSize460,y                  ;Set the Tile size of the tile Y
    PLY

    INY
    INY
    INY
    INY                                 ;Next OAM Slot
    CPY #$00FD
    BCS .return                         ;Y can't be more than #$00FD

    DEX
    BMI .return
    CPX !Scratch4                       ;if X < start position or is negative then return
    BCS -                               ;else loop

.return
    SEP #$10
    PLX                                 ;Restore X
    
    LDY #$FF                            ;Allows mode of 8 or 16 bits
    LDA !Scratch8                       ;Load the number of tiles used by the frame
    JSL $01B7B3|!rom                  		;This insert the new tiles into the oam, 
                                        ;A = #$00 => only tiles of 8x8, A = #$02 = only tiles of 16x16, A = #$04 = tiles of 8x8 or 16x16
                                        ;if you select A = #$04 then you must put the sizes of the tiles in !TileSize
RTS
;>EndRoutine

;All words that starts with '@' and finish with '.' will be replaced by Dyzen

;>Table: FramesLengths
;>Description: How many tiles use each frame.
;>ValuesSize: 16
FramesLength:
    dw $0002,$0002,$0002,$0002,$0002,$0002,$0002,$0003,$0003
	dw $0002,$0002,$0002,$0002,$0002,$0002,$0002,$0003,$0003
;>EndTable


;>Table: FramesFlippers
;>Description: Values used to add values to FramesStartPosition and FramesEndPosition
;To use a flipped version of the frames.
;>ValuesSize: 16
FramesFlippers:
    dw $0000,$0012
;>EndTable


;>Table: FramesStartPosition
;>Description: Indicates the index where starts each frame
;>ValuesSize: 16
FramesStartPosition:
    dw $0002,$0005,$0008,$000B,$000E,$0011,$0014,$0018,$001C
	dw $001F,$0022,$0025,$0028,$002B,$002E,$0031,$0035,$0039
;>EndTable

;>Table: FramesEndPosition
;>Description: Indicates the index where end each frame
;>ValuesSize: 16
FramesEndPosition:
    dw $0000,$0003,$0006,$0009,$000C,$000F,$0012,$0015,$0019
	dw $001D,$0020,$0023,$0026,$0029,$002C,$002F,$0032,$0036
;>EndTable


;>Table: Tiles
;>Description: Tiles codes of each tile of each frame
;>ValuesSize: 8
Tiles:
    
Frame0_Frame0_Tiles:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame1_Frame1_Tiles:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame2_Frame2_Tiles:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame3_Frame3_Tiles:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame4_Frame4_Tiles:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame5_Frame5_Tiles:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame6_Frame6_Tiles:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame7_angered_Tiles:
	db !AngyKrackTopRight,!AngyKrackBottomRight,!AngyKrackMiddleLeft,!AngyKrackBottomLeft
Frame8_angered2_Tiles:
	db !AngyKrackTopRight,!AngyKrackBottomRight,!AngyKrackMiddleLeft,!AngyKrackBottomLeft
Frame0_Frame0_TilesFlipX:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame1_Frame1_TilesFlipX:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame2_Frame2_TilesFlipX:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame3_Frame3_TilesFlipX:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame4_Frame4_TilesFlipX:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame5_Frame5_TilesFlipX:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame6_Frame6_TilesFlipX:
	db !KrackBodyTop,!KrackBodyBottom,!KrackEyeFrame
Frame7_angered_TilesFlipX:
	db !AngyKrackTopRight,!AngyKrackBottomRight,!AngyKrackMiddleLeft,!AngyKrackBottomLeft
Frame8_angered2_TilesFlipX:
	db !AngyKrackTopRight,!AngyKrackBottomRight,!AngyKrackMiddleLeft,!AngyKrackBottomLeft
;>EndTable

;>Table: XDisplacements
;>Description: X Displacement of each tile of each frame
;>ValuesSize: 8
XDisplacements:
    
Frame0_Frame0_XDisp:
	db $00,$00,$01
Frame1_Frame1_XDisp:
	db $00,$00,$02
Frame2_Frame2_XDisp:
	db $00,$00,$03
Frame3_Frame3_XDisp:
	db $00,$00,$01
Frame4_Frame4_XDisp:
	db $00,$00,$02
Frame5_Frame5_XDisp:
	db $00,$00,$03
Frame6_Frame6_XDisp:
	db $00,$00,$04
Frame7_angered_XDisp:
	db $01,$01,$F9,$F9
Frame8_angered2_XDisp:
	db $FF,$FF,$F7,$F7
Frame0_Frame0_XDispFlipX:
	db $00,$00,$07
Frame1_Frame1_XDispFlipX:
	db $00,$00,$06
Frame2_Frame2_XDispFlipX:
	db $00,$00,$05
Frame3_Frame3_XDispFlipX:
	db $00,$00,$07
Frame4_Frame4_XDispFlipX:
	db $00,$00,$06
Frame5_Frame5_XDispFlipX:
	db $00,$00,$05
Frame6_Frame6_XDispFlipX:
	db $00,$00,$04
Frame7_angered_XDispFlipX:
	db $FF,$FF,$07,$07
Frame8_angered2_XDispFlipX:
	db $01,$01,$09,$09
;>EndTable
;>Table: YDisplacements
;>Description: Y Displacement of each tile of each frame
;>ValuesSize: 8
YDisplacements:
    
Frame0_Frame0_YDisp:
	db $F0,$00,$FA
Frame1_Frame1_YDisp:
	db $F0,$00,$FA
Frame2_Frame2_YDisp:
	db $F0,$00,$FA
Frame3_Frame3_YDisp:
	db $F0,$00,$FC
Frame4_Frame4_YDisp:
	db $F0,$00,$FB
Frame5_Frame5_YDisp:
	db $F0,$00,$FB
Frame6_Frame6_YDisp:
	db $F0,$00,$FA
Frame7_angered_YDisp:
	db $F0,$00,$F8,$00
Frame8_angered2_YDisp:
	db $F0,$00,$F8,$00
Frame0_Frame0_YDispFlipX:
	db $F0,$00,$FA
Frame1_Frame1_YDispFlipX:
	db $F0,$00,$FA
Frame2_Frame2_YDispFlipX:
	db $F0,$00,$FA
Frame3_Frame3_YDispFlipX:
	db $F0,$00,$FC
Frame4_Frame4_YDispFlipX:
	db $F0,$00,$FB
Frame5_Frame5_YDispFlipX:
	db $F0,$00,$FB
Frame6_Frame6_YDispFlipX:
	db $F0,$00,$FA
Frame7_angered_YDispFlipX:
	db $F0,$00,$F8,$00
Frame8_angered2_YDispFlipX:
	db $F0,$00,$F8,$00
;>EndTable
;>Table: Sizes.
;>Description: size of each tile of each frame
;>ValuesSize: 8
Sizes:
    
Frame0_Frame0_Sizes:
	db $02,$02,$00
Frame1_Frame1_Sizes:
	db $02,$02,$00
Frame2_Frame2_Sizes:
	db $02,$02,$00
Frame3_Frame3_Sizes:
	db $02,$02,$00
Frame4_Frame4_Sizes:
	db $02,$02,$00
Frame5_Frame5_Sizes:
	db $02,$02,$00
Frame6_Frame6_Sizes:
	db $02,$02,$00
Frame7_angered_Sizes:
	db $02,$02,$02,$02
Frame8_angered2_Sizes:
	db $02,$02,$02,$02
Frame0_Frame0_SizesFlipX:
	db $02,$02,$00
Frame1_Frame1_SizesFlipX:
	db $02,$02,$00
Frame2_Frame2_SizesFlipX:
	db $02,$02,$00
Frame3_Frame3_SizesFlipX:
	db $02,$02,$00
Frame4_Frame4_SizesFlipX:
	db $02,$02,$00
Frame5_Frame5_SizesFlipX:
	db $02,$02,$00
Frame6_Frame6_SizesFlipX:
	db $02,$02,$00
Frame7_angered_SizesFlipX:
	db $02,$02,$02,$02
Frame8_angered2_SizesFlipX:
	db $02,$02,$02,$02
;>EndTable

;>End Graphics Section

;Don't Delete or write another >Section Animation or >End Section
;All code between >Section Animations and >End Animations Section will be changed by Dyzen : Sprite Maker
;>Section Animations
;######################################
;########## Animation Space ###########
;######################################

;This space is for routines used for graphics
;if you don't know enough about asm then
;don't edit them.
InitWrapperChangeAnimationFromStart:
	PHB
    PHK
    PLB
	STZ !AnimationIndex,x
	JSR ChangeAnimationFromStart
	PLB
	RTL

ChangeAnimationFromStart_Animation0:
	STZ !AnimationIndex,x
	JMP ChangeAnimationFromStart
ChangeAnimationFromStart_Animation1:
	LDA #$01
	STA !AnimationIndex,x
	JMP ChangeAnimationFromStart
ChangeAnimationFromStart_Animation2:
	LDA #$02
	STA !AnimationIndex,x


ChangeAnimationFromStart:
	STZ !AnimationFrameIndex,x

	STZ !Scratch1
	LDA !AnimationIndex,x
	STA !Scratch0					;$00 = Animation index in 16 bits

	STZ !Scratch3
	LDA !AnimationFrameIndex,x
	STA !Scratch2					;$02 = Animation Frame index in 16 bits

	STZ !Scratch5
	STX !Scratch4					;$04 = sprite index in 16 bits

	REP #$30						;A7X/Y of 16 bits
	LDX !Scratch4					;X = sprite index in 16 bits

	LDA !Scratch0
	ASL
	TAY								;Y = 2*Animation index

	LDA !Scratch2
	CLC
	ADC AnimationIndexer,y
	TAY								;Y = Position of the first frame of the animation + animation frame index

	SEP #$20						;A of 8 bits

	LDA Frames,y
	STA !FrameIndex,x				;New Frame = Frames[New Animation Frame Index]

	LDA Times,y
	STA !AnimationTimer,x			;Time = Times[New Animation Frame Index]

	LDA !Scratch2
	STA !AnimationFrameIndex,x

	SEP #$10						;X/Y of 8 bits
	LDX !Scratch4					;X = sprite index in 8 bits
RTS
	

;>Routine: AnimationRoutine
;>Description: Decides what will be the next frame.
;>RoutineLength: Short
AnimationRoutine:
    LDA !AnimationTimer,x
    BEQ +

	RTS

+
	STZ !Scratch1
	LDA !AnimationIndex,x
	STA !Scratch0					;$00 = Animation index in 16 bits

	STZ !Scratch3
	LDA !AnimationFrameIndex,x
	STA !Scratch2					;$02 = Animation Frame index in 16 bits

	STZ !Scratch5
	STX !Scratch4					;$04 = sprite index in 16 bits

	REP #$30						;A7X/Y of 16 bits
	LDX !Scratch4					;X = sprite index in 16 bits

	LDA !Scratch0
	ASL
	TAY								;Y = 2*Animation index

	INC !Scratch2					;New Animation Frame Index = Animation Frame Index + 1

	LDA !Scratch2			        ;if Animation Frame index < Animation Lenght then Animation Frame index++
	CMP AnimationLenght,y			;else go to the frame where start the loop.
	BCC +							

	LDA AnimationLastTransition,y
	STA !Scratch2					;New Animation Frame Index = first frame of the loop.

+
	LDA !Scratch2
	CLC
	ADC AnimationIndexer,y
	TAY								;Y = Position of the first frame of the animation + animation frame index

	SEP #$20						;A of 8 bits

	LDA Frames,y
	STA !FrameIndex,x				;New Frame = Frames[New Animation Frame Index]

	LDA Times,y
	STA !AnimationTimer,x			;Time = Times[New Animation Frame Index]

	LDA !Scratch2
	STA !AnimationFrameIndex,x

	SEP #$10						;X/Y of 8 bits
	LDX !Scratch4					;X = sprite index in 8 bits
RTS
;>EndRoutine

;All words that starts with '>' and finish with '.' will be replaced by Dyzen

AnimationLenght:
	dw $000F,$0001,$0002

AnimationLastTransition:
	dw $0000,$0000,$0000

AnimationIndexer:
	dw $0000,$000F,$0010

Frames:
	
Animation0_Animation0_Frames:
	db $00,$01,$02,$01,$00,$01,$02,$01,$00,$03,$04,$05,$06,$02,$01
Animation1_Animation1_Frames:
	db $07
Animation2_Animation2_Frames:
	db $07,$08

Times:
	
Animation0_Animation0_Times:
	db $4D,$04,$4D,$04,$4D,$04,$4D,$04,$80,$80,$02,$02,$80,$04,$04
Animation1_Animation1_Times:
	db $02
Animation2_Animation2_Times:
	db $01,$01
;>End Animations Section

;Don't Delete or write another >Section Hitbox Interaction or >End Section
;All code between >Section Hitboxes Interaction and >End Hitboxes Interaction Section will be changed by Dyzen : Sprite Maker
;>Section Hitboxes Interaction
;######################################
;######## Interaction Space ###########
;######################################

 
ReturnNoContact:
	CLC                       
	RTS
InteractMarioSprite:    
	%SubHorzPos()
	LDA !ScratchF                  
	CLC                       
	ADC #$50                
	CMP #$A0                
	BCS ReturnNoContact       ; No contact, return 
	%SubVertPos()
	LDA !ScratchE                   
	CLC                       
	ADC #$60                
	CMP #$C0                
	BCS ReturnNoContact       ; No contact, return 
	LDA $71    ; \ If animation sequence activated... 
	CMP #$01                ;  | 
	BCS ReturnNoContact       ; / ...no contact, return 
	LDA #$00                ; \ Branch if bit 6 of $0D9B set? 
	BIT $0D9B|!addr               ;  | 
	BVS +           ; / 
	LDA $13F9|!addr ; \ If Mario and Sprite not on same side of scenery... 
	EOR !SpriteBehindEscenaryFlag,x ;  |
+
	BNE ReturnNoContact2
	JSL $03B664|!rom				; MarioClipping
	JSR Interaction

	BCC ReturnNoContact2
	LDA !ScratchE
	CMP #$01
	BNE +
	JSR DefaultAction
+
	SEC
	RTS
ReturnNoContact2:
	CLC
	RTS

Interaction:
    STZ !ScratchE
	LDA !GlobalFlip,x
    ASL
	TAY                     ;Y = Flip Adder, used to jump to the frame with the current flip

    LDA !FrameIndex,x
	STA !Scratch4
	STZ !Scratch5

    REP #$20
	LDA !Scratch4
	ASL
	CLC
	ADC HitboxAdder,y
	REP #$10
	TAY

    LDA FrameHitboxesIndexer,y
    TAY
    SEP #$20

-
    LDA FrameHitBoxes,y
    CMP #$FF
    BNE +
    LDA !ScratchE
    BNE ++
	SEP #$10
	LDX !SpriteIndex
    CLC
    RTS
++
	SEP #$10
	LDX !SpriteIndex
    SEC
    RTS
+
    STA !Scratch4
    STZ !Scratch5
    PHY

    REP #$20
    LDA !Scratch4
    ASL
    TAY

    LDA HitboxesStart,y
    TAY
    SEP #$20
+

	STZ !ScratchA
    LDA Hitboxes+1,y
    STA !Scratch4           ;$04 = Low X Offset
    BPL +
    LDA #$FF
    STA !ScratchA           ;$0A = High X offset
+

	STZ !ScratchB
    LDA Hitboxes+2,y
    STA !Scratch5           ;$05 = Low Y Offset
    BPL +
    LDA #$FF
    STA !ScratchB           ;$0B = High Y Offset
+

    LDA Hitboxes+3,y
    STA !Scratch6           ;$06 = Width

    LDA Hitboxes+4,y
    STA !Scratch7           ;$07 = Height

	PHY
	SEP #$10
	LDX !SpriteIndex

	LDA !SpriteXHigh,x
	XBA
	LDA !SpriteXLow,x
	REP #$20
	PHA
	SEP #$20

	LDA !ScratchA
	XBA
	LDA !Scratch4
	REP #$20
	CLC
	ADC $01,s
	PHA
	SEP #$20
	PLA 
	STA !Scratch4
	PLA
	STA !ScratchA
	PLA
	PLA

	LDA !SpriteYHigh,x
	XBA
	LDA !SpriteYLow,x
	REP #$20
	PHA
	SEP #$20

	LDA !ScratchB
	XBA
	LDA !Scratch5
	REP #$20
	CLC
	ADC $01,s
	PHA
	SEP #$20
	PLA 
	STA !Scratch5
	PLA
	STA !ScratchB
	PLA
	PLA

    JSL $03B72B|!rom
	REP #$10
	BCS ++
	PLY
	PLY
	INY
	JMP -
++
	PLY
	PLY
	LDA !ScratchE
	ORA #$01
	STA !ScratchE
	SEP #$10
	LDX !SpriteIndex
	SEC
	RTS

HitboxAdder:
    dw $0000,$0012

FrameHitboxesIndexer:
    dw $0000,$0002,$0004,$0006,$0008,$000A,$000C,$000E,$0010
	dw $0012,$0014,$0016,$0018,$001A,$001C,$001E,$0020,$0022

FrameHitBoxes:
    db $00,$FF
	db $00,$FF
	db $00,$FF
	db $00,$FF
	db $00,$FF
	db $00,$FF
	db $00,$FF
	db $01,$FF
	db $01,$FF
	
	db $02,$FF
	db $02,$FF
	db $02,$FF
	db $02,$FF
	db $02,$FF
	db $02,$FF
	db $02,$FF
	db $03,$FF
	db $03,$FF
	

HitboxesStart:
    dw $0000,$0006,$000C,$0012

Hitboxes:
    db $01,$B8,$98,$A0,$78,$00
	db $01,$00,$F8,$08,$18,$00
	db $01,$B8,$98,$A0,$78,$00
	db $01,$08,$F8,$08,$18,$00
	

;This routine will be executed when mario interact with a standar hitbox.
;It will be excecuted if $0E is 1 after execute Interaction routine
DefaultAction:
	LDA !SpriteHOffScreenFlag,x
	BNE +
	LDA !AnimationIndex,x
	BNE .attack
	LDA #$03 : STA !NoHitTimer,x
	; set animation index
	LDA #$02 : STA !AnimationIndex,x
	STZ !AnimationFrameIndex,x
	STZ !AnimationTimer,x ; problem code #475 fix lordy
	; store delay before attack
	LDA #$20 : STA !AimTimer,x
	; yoshi tounge noise
	LDA #$21 : STA $1DFC|!Base2
	; freeze Krack in place temporarily
	LDA !sprite_x_low,x : STA !SpriteXLowTarget,x
	LDA !sprite_x_high,x : STA !SpriteXHighTarget,x
+	RTS

.attack
	LDA !NoHitTimer,x
	BNE +
	JSL $00F606|!BankB ; kill mario
+	RTS